local mission = {}
local eventIndex = 1
local eventTime = 0

local function player_addEvent(player, waitT, fn)
	table.insert(player.events, {t=waitT,handler=fn})
end

local function think(player)
	local dt = Timer:GetTimeDiff()
	if #player.events >= eventIndex then
		local r = player.events[eventIndex]
		r.t = r.t - dt
		eventTime = r.t
		if r.t <= 0 then
			r.handler(player)
			--table.remove(player.events, 1)
			eventIndex = eventIndex + 1 -- use another event
			if #player.events >= eventIndex then -- just to be sure u have time for right eventIndex
				r = player.events[eventIndex]
				eventTime = r.t
			end
		end
	end
end

local function init(player)
	--local enemy = player:GetEnemy(0)
	--if not enemy then
	--	return
	--end
	--local enemyPos = enemy:GetPosition()
	local playerPos = player:GetPosition()

	--local rallyPoint = (enemyPos + playerPos) * 0.5
  player:AISetNumberOfReservePeasants(0)
  player:SetPopulationLimit(80)
  --player:AISetAutoMode(true)
  player:AISetEverythingVisible(true)
  --player:AIDestroyTowersDisconected() --they will be rebuilt latter
  --player:AIIgnoreAllNonPeasantUnits(true) -- left all predefined units intact
  --ai left all nonpeasant units with set object key intact !!!!

	player.t = 0
	player.events = {}
	player.addEvent = player_addEvent
    
	player:addEvent(4, function()   --after 4 seconds
      player:AISetupGathering(10, 50,0)      --wheat
		  player:AISetupGathering(6, 50,1)      --wood
      player:AISetupGathering(6, 50,2)      --stone
      player:AISetupGathering(6, 50,3)      --iron
	  end)
	
  player:addEvent(120, function() --after next 120 seconds
      player:AISetupGathering(1, 40,5)    --planks
      player:AISetupGathering(1, 40,4)    --stone block
	  end)
    
  player:addEvent(150, function() --after next 120 seconds
      player:AISetupGathering(1, 40,7)    --weapons
      player:AISetupGathering(1, 40,6)    --bread
	  end)
end

function OnThink(self)
    if not self.init_done then
    mission.enemy = Citadels.GetPlayer(1)
    
    Debug:Log('Ai Script: Init Start')
    init(mission.enemy)
    if self.load and #mission.enemy.events >= eventIndex then
			mission.enemy.events[eventIndex].t = eventTime -- restore time
		end
    
    self.init_done = true
  end
  think(mission.enemy)
end

function OnSerialize(self, ar)
    local arVersion = 1
	if (ar:IsLoading()) then
     if not Citadels.GetLoadGameRunning() then return end
     --local s = ar:Read()
     Debug:Log('Script Load Start')
     local ver = ar:Read()
	 eventIndex = ar:Read()
	 eventTime = ar:Read()
	 Debug:Log('Script Load End')
     self.load = true
   else
	Debug:Log('Script Save Start')
    ar:Write(arVersion)
	ar:Write(eventIndex)
	ar:Write(eventTime)
    Debug:Log('Script Save End')
   end
end